define([
    'Layout',
    'modules/notifications/notifications-module',
    'modules/notifications/notifications-layout-view',
],
function(Layout, notificationsModule, NotificationsLayoutView) {
    'use strict';

    describe('Notifications Layout View', function() {
        var view;
        var $view;
        var layout = new Layout();

        layout.render();

        beforeEach(function() {
            spyOn(NotificationsLayoutView.prototype, 'fetchNotificationsCollection').and.callFake(function() {
                var resolved = new $.Deferred();
                resolved.resolve();
                return resolved;
            });

            view = new NotificationsLayoutView();
            layout.showChildView('content', view);
            $view = view.$el;
        });

        afterEach(function() {
            layout.getRegion('content').empty();
        });

        it('has button to return to appointments/requests', function() {
            var backButton = view.$el.find('#back-btn');
            expect(backButton.length).toEqual(1);
        });
        it("has a primary content header 'Notifications", function() {
            expect($view.find('.primary-header').find('h2')
                .text()).toEqual('Notifications');
        });

        it('has a region for the notifications list', function() {
            expect($view.has(view.regions.notificationsListRegion).length).toEqual(1);
        });
    });

}
);
